10 TROFF
20 QL=1
30 DUR=1:TONE=100 :DEL=1:SIZ=0:REV=0
40   REM             carlsons icosahedron striped singing logo
50   REM =======================================================================
60   REM                    reassign soft keys
70   KEY 1,"LIST "
80   KEY 3,"LOAD" +CHR$(34)
90   KEY 4,"SAVE" +CHR$(34)
100   KEY 6,"CLS"+CHR$(13)
110   KEY 2,"RUN"+CHR$(13)
120   KEY 5,"CONT"+CHR$(13)
130   KEY 7,"TRON"+CHR$(13):KEY 8,"TROFF"+CHR$(13)
140  KEY 9,"SCREEN "
150  KEY 8 ,"color 15, 1,0"+CHR$(13)
160  KEY 9 ,"screen 0,0 "+CHR$(13)
170  KEY 10,"width 80" +CHR$(13)
180  WIDTH 80
190  SCREEN 0,0 :KEY ON
200  COLOR 15, 1,0
210 KEY 9,"GOTO 250"+CHR$(13)
220 KEY 8,"B=B+10:print B"+CHR$(13)
230 KEY 7,"B=B-15:print B"+CHR$(13)
240 B=17
250 BB=B:B=(B+2) MOD 100:C=(B MOD 10):D=(B\10):CK=BB MOD 10:DK=BB\10
260 KEY 10,"LIST "+CHR$(48+DK)+CHR$(48+CK)+"00-"+CHR$(48+D)+CHR$(48+C)+"00"             +CHR$(13):CLS:PRINT B-2:'STOP
270  WIDTH 80
280  SCREEN 0,0 :KEY ON
290  COLOR 15, 1,0
300 '  GOTO 570
310 REM =========================================================================
320 REM                             directory
330 KEY 9 ,"screen 0,0 "+CHR$(13)
340 ON  DEFN GOTO 350: ON NBRXN GOTO 450: ON ARCT  GOTO 980:ON EQAT GOTO 1030:
350 REM =========================================================================
360 REM             carlsons icosahedron striped singing logo
370 SCREEN 0,0
380 FOR I=0 TO 50
390 TROFF
400 COLOR I MOD 8,(I+2)MOD 8
410 PRINT           "CARLSON'S ICOSAHEDRON @"
420 SOUND 50 +I*100,1
430 NEXT
440 CLS
450 REM ========================================================================
460 REM explanatory introduction
470   SCREEN 0,0: WIDTH 80:COLOR 15,1,0:KEY OFF
480 PRINT "           Carlson's Icosahedron-----";CHR$(13)
490  PRINT "      The Rubiks cube type puzzle based on the icosahedron.";CHR$(13)
500  PRINT "           The icosahedron is the largest regular polyhedron consisting of  20   equilateral triangles and 30  edges , one edge between every pair of adjacent   triangles. In the same way that Rubiks cube has 3 pairs of opposing"
510 PRINT " faces making a total of 6, The Icosahedron has 6 opposing pairs of faces         making  a total of 12 .Each face contains 5 triangles and 5 edges    and as     you rotate the faces you scramble the puzzle. ";CHR$(13)
520  PRINT " The number  keys   1-9   rotates face 1-face  9                                             0  -  =      rotates face 10-face 12                                the cursor  keys  reverse,double,repeat,delete,or randomize.  "
530 PRINT  "      end restarts,cursor left turns sound off,ctrl-brk quits ";       CHR$(13)
540 PRINT "      You will be seeing the whole icosahedron at once, face #1 the north pole    is in the center of the screen, face #12 the south pole is spread around the    border of the puzzle. The southern faces are enlarged by this projection";CHR$(13)
550 PRINT  "     Scramble the faces yourself or by the random mover, then try to unscramble  the puzzle. The icon trail on the left shows how to backtrack."
555 LOCATE 25,1:PRINT " Robert Carlson, 319 Lunada Ct. Los Altos, CA 94022. Happy Solving!";
560 REM =======================================================================
570 REM                shift screen to right ,play computer? branch
580 REM OUT 980,2:OUT 981,85
590 SCREEN 0,0: WIDTH 80:COLOR 15,1,0
600 REM INPUT  "play versus computer?1=yes";VERSUS
610 REM IF VERSUS=1 THEN INPUT "level of difficulty ? 1 TO 12";LEVEL
620 REM IF VERSUS=1 THEN RANDOMIZE
630 DIM TWIST(12),STACK(200,2)
640 REM PRINT RND,RND(0),INT(RND*12),INT(RND*11)
650 REM =======================================================================
660 REM                    branch to play or construct
670 REM  THIS IS TOTAL VECTOR METHOD  ICOSAHEDRON
680  IF QL=1 THEN GOTO 3230
690 IF QL=2 THEN GOTO 740
700 REM =======================================================================
710 REM                      set parameters
720 SCREEN 1,0:FORG=1 :BACK=1 :BORD=0:COLOR FORG,BACK,BORD:KEY OFF
730 TRON: KEY OFF:COLOR 1,1
740 REM               change sec to  8 for cube, 10 for icosahedron
750 PI=3.141593  : DR=PI/180  : RD=180/PI : SEC=10: RS=SEC/(2*PI):  SR=1/RS
760 SCALE=100    :ASPECT=1    :  X=160     :  Y=100
770 ARCTIC=  1/(2*COS(54*DR))      :AR=ARCTIC
780 CHORD= 1+1/(2*COS(36*DR))      :CH=CHORD
790 EQUATOR= ( SQR(CHORD^2 +1) )/2 :EQ=EQUATOR
800 REM =======================================================================
810 REM                      pole sector functions defs
820 DEF FNA(N,Q)=-(Q=0)*(  N MOD 2 )                                                             +(Q=1)*  (N MOD (SEC+1) <>0 )*(N MOD SEC)                                       +(Q=1)*  (N MOD (SEC+1)  =0 )*(   SEC   )
830 DEF FNAA(P,S)=-(S =SEC)*( P -(P=1)*SEC)                                                       -(S<>SEC)*( S -(S=0)*SEC)
840  DEF FNT(S,Q,E)= (Q=0)*(COS(S*SR)*ARCTIC)^(E+1)*(S<>SEC)                                         +(Q=1)*(SIN(S*SR)*ARCTIC)^(E+1)*(S<>SEC)
850 DEF FNB(P,S,Q)=-(Q=0)*FNT(S,0,0)                                                               -(Q=1)*FNT(S,1,0)                                                               -(Q=2)*(.5-P)*2*SQR(EQ^2-FNT(S,0,1)-FNT(S,1,1))
860  DEF FNC(U,V,W,Q)=                                                              -( (U^2+V^2) <> 0)*-(Q=0)*(-(U<=0)*PI +ATN( V/ (      U     + 1E-09 ) ) )       -( (U^2+V^2) <> 0)*-(Q=1)*(  PI/2     +ATN( W/ (SQR(U^2+V^2)+ 1E-09 ) ) )
870 DEF FND(LON,LAT,Q)=-(Q=0)*(X+CINT(  COS(LON)*LAT*SCALE       ) )                                   -(Q=1)*(Y-CINT(  SIN(LON)*LAT*SCALE*ASPECT) )
880 REM  ======================================================================                         MAKE NEIGHBORS AND OPPOSITES
890 DIM BR(13,6),XN(12,12),T(12,12,12),C(12,3)
900 REM                                                                              MAKE OPPOSITES AND STORE COORDINATES
910 FOR N=0 TO 5
920 P  =FNA(N,0)   :  S  =FNA(N,1)
930 PP=-(P=0)      :  SS =-(S<>SEC)*((S +5) MOD SEC )-(S=SEC)*(SEC)
940 NN=FNAA(PP,SS) : XN(N,0)=N :XN(N,1)=NN: XN(NN,0)=NN: XN(NN,1)=N
950 FOR Q=0 TO 2:C(N,Q)=FNB(P,S,Q):C(NN,Q)=-C(N,Q):NEXT Q:GOTO 970
960 PRINT N,C(N,0),C(N,1),C(N,2)
970 NEXT N
980 REM =======================================================================                         MAKE ARCTIC NEIGHBORS
990 FOR N=0 TO SEC+1 STEP SEC+1: FOR L=0 TO (SEC/2)-1
1000 BR(N,L)=-(N=0)*( 2*(L+1) )-(N=SEC+1)*( SEC -(2*L+1)  )
1010 BR(BR(N,L),0)=N
1020 NEXT L:NEXT N
1030 REM =======================================================================                      MAKE EQUATORIAL NEIGHBORS
1040 FOR P=0 TO SEC+1 STEP SEC+1
1050 FOR L=0 TO (SEC/2)-1: V=BR(P,L): BR(V,0)=P
1060 FOR Q=-2 TO 2
1070 A=(Q+SEC/2) MOD (SEC/2):B=(L-Q*( (Q^2=4)-(Q^2=1) )+SEC/2) MOD (SEC/2)
1080 BR(V,A) = XN( BR(P,B),(Q+3) MOD 2 ):NEXT Q:BR(V,0)=P:GOTO 1100
1090 BR(V,0)=P:PRINT P;L;V;BR(V,0);BR(V,1);BR(V,2);BR(V,3);BR(V,4)
1100 NEXT L:NEXT P
1110 IF QL=2 THEN GOTO 4170
1120 REM =======================================================================              vector addition FNV0,projection to screen FNS1
1130 DEF FNV0(C,K,D,L,E,M,Q)=C*C(K,Q)+D*C(L,Q)+E*C(M,Q)
1140 DEF FNS1(U,V,W,Q)=-(Q=0)*X-(Q=1)*Y +(-(Q=0)*U+(Q=1)*V)/SQR(U^2+V^2+1E-16)            *SIN(.8*ATN( SQR(U^2+V^2)/(SQR(U^2+V^2+W^2)+W+1E-16) )  )                              *SCALE*(-(Q=0)-(Q=1)*ASPECT)
1150 DEF FNVS(C,K,D,L,E,M,Q)=                                                            FNS1(FNV0(C,K,D,L,E,M,0),FNV0(C,K,D,L,E,M,1),FNV0(C,K,D,L,E,M,2),Q)
1160 REM PRINT FNVS(0,9,5 ,11 ,5,7,0)
1170 REM =======================================================================                  draws pentagons
1180     TROFF:CLS:CLS:BACK=1:PALETTE=0 :COLOR BACK,PALETTE:FORG=3
1190 REM  fOR Q=0 TO 0:IF Q=1 THEN CLS
1200 FOR KK=0  TO 10                 :K= KK MOD 10 + 1:XK=XN(K,1)
1210 FOR II=-6+4*(K MOD 2) TO 4-4*(K MOD 2)  STEP 2-(K MOD 2):I=(II +10) MOD 10
1220 L=BR(K, CINT(I/2)  MOD 5): M=BR(K, FIX((I/2)+1) MOD 5)
1230 XL=XN(L,1):XM=XN(M,1)
1240 IF Q=1 THEN S0=T(XM, L, K):S1=T(  M,XL, K): GOTO 1270
1250 S0=FNVS((1+(I MOD 2)),K,1,L,1,M,0)  :T(XM, L, K)=CINT(S0)
1260 S1=FNVS((1+(I MOD 2)),K,1,L,1,M,1)  :T( M,XL, K)=CINT(S1)
1270 IF(II=-6+4*(K MOD 2))AND (KK=0) THEN PSET (S0,S1)
1280 CC=FORG+FASTPAINT
1290 DRAW "M=S0;,=S1;"
1300 NEXT II
1310 NEXT KK
1320 REM =======================================================================                  draws circles
1330 TROFF
1340 FOR K=0 TO 11
1350 FOR I=0 TO 4
1360 L=BR(K,I)
1370 M=BR(K,(I+1) MOD 5)
1380 FOR J=0 TO 12 STEP 2-10*((K MOD 11)=0)-0*(K MOD 2=0)
1390 D=12-J    :C=.45+((J-6)^2)/30
1400 S0=FNVS(C,K,D,L,J,M,0)
1410 S1=FNVS(C,K,D,L,J,M,1)
1420 IF K=10 GOTO 1450
1430 IF  ((K MOD 11)MOD 5)+((L MOD 11)MOD 5)+J=0                                                   THEN  R=SQR((S0-X)^2+(S1-Y)^2)+ 1*(K=5)                                    : CIRCLE (X,Y),R,3, , ,ASPECT: IF (K MOD 11)=0 GOTO 1480
1440 IF(K MOD 11)=0 GOTO 1480
1450 IF (I+J)=0 OR ( (K MOD 2)=1  AND ABS(J-3*I+2*(I=4))<=2  AND (I MOD 4)=0  )                  THEN PSET (S0,S1)
1460 REM if hatchmaker then color =0
1470 DRAW "M=S0;,=S1;"
1480 NEXT J
1490 NEXT I :NEXT K
1500 PAINT (0 ,100),0:PAINT (640,100),0
1510 GOTO 1520
1520 REM ======================================================================                     paint the points store the colors
1530 FOR K=0 TO 11
1540 COL=FNA(K,1)MOD 5 -(FNA(K,1)=10)*5:KOL= COL   MOD 3 :KKOL=(KOL+1)MOD 3
1550 T(K,K,K)=COL
1560 FOR I=0 TO 4: LOCATE 1,1: PRINT "PAINT";K;"NBR";I
1570 L=BR(K,I): M=BR(K,(I+1) MOD 5)
1580 L(0)=K:L(1)=K:L(2)=L:M(0)=K:M(1)=L:M(2)=M
1590 FOR J=0      TO 2
1600 LJ=L(J):MJ=M(J)
1610 XLJ=XN(LJ,1):XMJ=XN(MJ,1)
1620 REM IF Q=1 THEN  S0=T(K,LJ,XMJ):S1=T(K,XLJ,MJ):GOTO 815
1630 ELV=1-( K=11):SC=3/ELV
1640 S0=FNVS(SC,K,1,LJ,1,MJ,0)
1650 S1=FNVS(SC,K,1,LJ,1,MJ,1)
1660 T(K,LJ,XMJ)=S0:T(K,XLJ,MJ)=S1
1670 T(K,LJ,MJ)=COL:T(MJ,LJ,K)=COL
1680 REM PSET(S0,S1),3
1690 KOL=COL MOD 3:KKOL=(KOL+1)MOD 3
1700 TIL$=CHR$(&H44*KOL + &H11*KKOL) +CHR$(&H11*KOL + &H44*KKOL)
1710 IF COL<=2 THEN PAINT(S0,S1),KOL,3
1720 IF COL> 2 THEN PAINT(S0,S1),TIL$,3
1730 NEXT J
1740 NEXT I
1750 NEXT K:STOP:GOTO 3910
1760 REM ==============================make sound on/off and size array
1770 SOU$(1)=" on":SOU$(0)="off" :REV=0:SIZ=0:ROT=1
1780 REM ======================================================================                          disable softkeys, brighten display
1790 DIAG=0:LOCATE 24,1 :PRINT SPACE$(14);
1805 LOCATE 16,33:PRINT "twists";CHR$(24)
1810 LOCATE 18,34:PRINT "repeat";
1812 LOCATE 19,33:PRINT "delete";
1815 LOCATE 20,32:PRINT "restart";
1820 LOCATE 21,31:PRINT "sound on";
1830 LOCATE 22,30:PRINT "double off":
1840 LOCATE 23,29:PRINT "reverse off";
1850 LOCATE 24,28:PRINT "random moves" ;
1860 LOCATE 25,1 :PRINT "stack depth 0"
1870 LOCATE 25,25:PRINT "cursor keys "+CHR$(24)
1880 LOCATE 1,1:PRINT    "ready to play   " ;
1890 LOCATE 1,29:PRINT    "Carlson's";:LOCATE 2,29:PRINT "Icosahedron" ;
1900 LOCATE 3,33:PRINT    "twists"+CHR$(25);
1910 FOR Q=1 TO 10:KEY Q,"" :NEXT
1920 COLOR 17,0
1930 FOR COL=0 TO 5
1940 KOL=COL MOD 3:KKOL=(KOL-(COL>=3))MOD 3
1950 TIL$(COL)=CHR$(&H44*KOL + &H11*KKOL) +CHR$(&H11*KOL + &H44*KKOL -(COL=0))
1960 NEXT
1970 T0L$=CHR$(0):DIM SMIRK$(16)
1971 SMIRK$(0)="thinking?":SMIRK$(1)="go ahead!":SMIRK$(2)="too tough?"
1972 SMIRK$(3)="aw c'mon!":SMIRK$(4)="give up? ":SMIRK$(5)="not yet?  "
1973 SMIRK$(6)="waiting..":SMIRK$(7)="tricky...":SMIRK$(8)="too easy? "
1974 SMIRK$(9)="anytime..":SMIRK$(10)="so soon??":SMIRK$(11)="need help?"
1975 SMIRK$(12)="excuse me":SMIRK$(13)="backtrack?":SMIRK$(14)="repeat?   "
1976 SMIRK$(15)="delete?  "
1980 REM ======================================================================                          rotation subroutine
1990 LOCATE 1,1:PRINT    "ENTER (F1-F12)  " ;
2000 R=-1
2010 IF VERSUS=1 AND DEPTH<LEVEL THEN GOTO 2320
2020 GOTO 2060
2030 REM =================================subroutine scan for repeat
2040 G$=INKEY$:IF G$="" THEN 2040
2050 IF G$=F$ THEN RETURN ELSE F$=G$:GOTO 2110
2060 REM ============scan softkeys
2062 GOTO 2070
2065 BOP=(BOP+1)MOD 16:COLOR BOP,BOP+1:SOUND 40,DUR*10:LOCATE 1,30
2070 LOCATE 3,30:PRINT    SMIRK$(BOP);
2071 IF (BIP MOD 16)=0 THEN   LOCATE 3,30:PRINT SPACE$(10) ;
2072 BIP=(BIP+1)MOD 64 :IF BIP=0 THEN GOTO 2065
2080 LOCATE 1,1:PRINT    "hit a number twice";
2090 LOCATE 1,1:PRINT    "                  " ;
2095 COLOR 17,0
2100 F$=INKEY$:IF F$="" THEN 2070
2110 KJ=   ASC(RIGHT$(F$,1)):KK=(KJ+(KJ>68)*15)-59
2112 ROT=(1- 2*REV)*(1+SIZ):    K=((KK MOD 20)MOD 12)
2120 IF KJ=79 THEN PRINT CHR$(11)+"restart?      ";:GOSUB 2030:RUN
2130 IF KJ=75 THEN DYR=-(DUR=0):PRINT CHR$(11);"sound ";SOU$(DYR);"?";           :GOSUB 2040: DUR=DYR:LOCATE 21,31:PRINT"sound ";SOU$(DUR);:GOTO 2100
2140 IF KJ=72 THEN SYZ=-(SIZ=0):PRINT CHR$(11);"double ";SOU$(SYZ);"?";          :GOSUB 2040: SIZ=SYZ:ROT=(1-2*REV)*(1+SIZ):                                              LOCATE 22,30:PRINT "double "; SOU$(SIZ);:GOTO 2100
2150 IF KJ=80 THEN RYV=-(REV=0):PRINT CHR$(11);"reverse ";SOU$(RYV);"?";          :GOSUB 2040: REV=RYV:ROT=(1-2*REV)*(1+SIZ):                                             LOCATE 23,29:PRINT"reverse ";SOU$(REV);:GOTO 2100
2160 IF KJ=82 THEN COLOR BIP,BIP+1:BIP=BIP+1:GOTO 2100
2170 IF KJ=71    THEN  PRINT CHR$(11)+"repeat stack?";:GOSUB 2040:                              CYCLE=DEPTH-1:REPEAT=1: REP=0: GOTO 2340
2180 IF KJ=73 OR KJ=77 OR KJ=81 THEN LEV=ABS(LEVEL-(KJ=73)+(KJ=81)):                 PRINT CHR$(11);LEV;"random moves?";:GOSUB 2040:                                    PLACE=DEPTH:VERSUS=1:LEVEL=LEV:GOTO 2320
2190 IF KJ=83    THEN  PRINT CHR$(11)+"delete?    ";:GOSUB 2040:GOSUB 4030
2195 IF KJ>48 AND KJ<58 THEN K=KJ-49
2196 IF KJ=48 THEN K=9
2197 IF KJ=45 THEN K=10
2198 IF KJ=61 THEN K=11
2200 'SIGN=-(KK<20)+(KK>=20)
2220 IF K <0 OR K >11 THEN                            GOTO 2060
2230 REM======================================================= pause and flash
2240 LOCATE 1,1: PRINT  " ROTATE?  ";K+1;"x";ROT;:IF DIAG=1 GOTO 1880
2250 S0=T(K,K,XN(K,1)):S1=T(K,XN(K,1),K) :RF=2-(K=11)*92
2260 CIRCLE (S0,S1),RF,0,,,1    :CIRCLE(S0,S1),RF,3,,,1
2270 F$=INKEY$:IF F$=""      THEN 2260
2280 LOCATE 1,1:PRINT    "                  " ;
2290 QJ=   ASC(RIGHT$(F$,1))
2300 IF QJ<>KJ THEN  2110
2310 LOCATE 1,1: PRINT  "rotating  ";K+1;"x";ROT;:IF DIAG=1 GOTO 1880
2320 REM===========================================entry for computer opponent
2330 IF VERSUS=1 AND DEPTH <=LEVEL +PLACE    THEN K=(INT(RND* 12)+12)MOD 12:          LOCATE 1,1:PRINT LEVEL;" random moves"
2340 REM================================================entry for repeat stack
2350 IF REPEAT=1 THEN K=STACK(REP,0):ROT=STACK (REP,1):LOCATE 1,1                         :PRINT "repeating stack "
2360 REM ========================================================stack update
2370 DIP=DEPTH MOD 200
2380 STACK(DIP  ,0)=K:STACK(DIP  ,1)=ROT
2390 REM ====================================================entry for delete
2400 DM=(DEPTH\22) MOD 3:DN=-(DEPTH>66):  XX=(10+18*DM)+9*DN
2405 DD=12+8*(DEPTH MOD 22)+4*DN
2410 COL=T(K,K,K)*DEL:BAN=3*( K MOD 2)+1
2420 CIRCLE (XX ,DD),2+BAN  ,3,,,(1/BAN)
2430  PAINT(XX ,DD),TIL$(COL),3
2440 IF SGN(ROT)=-1 THEN PSET(XX-8,DD),3
2450 IF ABS(ROT)= 2 THEN CIRCLE(XX-8,DD),2,3*DEL
2460 IF DEL=0 THEN CIRCLE (XX ,DD),2+BAN  ,0,,,(1/BAN):PSET (XX-8,DD),0
2470 DEPTH=DEPTH+1+(DEL=0):DIP=(DEPTH MOD 200)
2480 LOCATE 25,1 :PRINT"stack depth ";DEPTH ;
2490 DEL=1
2500 REM -=========================================================add twist
2510 TWIST(K)=(TWIST(K)+ROT) MOD 5  :TWIST=0
2520 FOR I=0 TO 11:TWIST=TWIST+TWIST(I):NEXT
2530 LOCATE K+4, 34:PRINT K+1;  TWIST(K)
2540 'LOCATE 17 , 37:PRINT TWIST;
2550 REM==============rotate intended face and update mirror array
2560 GOSUB 4630
2570 FOR Q=0 TO 1: FOR I=0 TO 4
2580 L =BR(K,(I    )     ):M =BR(K,(I+1    ) MOD 5)
2590 LL=BR(K,(I+R+5)MOD 5):MM=BR(K,(I+1+R+5) MOD 5)
2600 A(0)=K: A(1)=L: A(2)=M: B(0)=K: B(1)=LL: B(2)=MM
2610 FOR P=2 TO 3:FOR C=0 TO P-1
2620 A0=A((0+C)MOD P): B0=B((0+C)MOD P)
2630 A1=A((1+C)MOD P): B1=B((1+C)MOD P)
2640 A2=A((2+C)MOD P): B2=B((2+C)MOD P)
2650 IF P=2 THEN A2=A1:A1=A0:B2=B1:B1=B0
2660 IF Q=1 THEN T(A2,A1,A0)=T(A0,A1,A2):     GOTO 2780
2670 COL=T(B2,B1,B0):T(A0,A1,A2)=COL:KOL=COL MOD 3:KKOL=(KOL+1)MOD 3
2680 XNA1=XN(A1,1):XNA2=XN(A2,1)
2690 S0=T(A0,A1,XNA2):S1=T(A0,XNA1,A2)
2700 PAINT (S0,S1),0   ,3
2710 TIL$=CHR$(&H44*KOL + &H11*KKOL) +CHR$(&H11*KOL + &H44*KKOL)
2720 IF COL<=2 THEN PAINT(S0,S1),KOL,3
2730 IF COL> 2 THEN PAINT(S0,S1),TIL$,3
2740 SOUND 50+COL*100,1
2750 REM IF DOTS =1 AND COL>2 THEN GOSUB 4040
2760 REM IF COL>2 THEN  PUT (64,0),D#,XOR
2770 XX=S0:YYY=S1
2780 NEXT C:NEXT P:NEXT I: NEXT Q
2790 REM ============return from fast flipper
2800 REM ============zero twist? give reward
2805 IF TWIST<>0 THEN 2890
2820 IF TWIST(0)=0 AND TWIST(1)=0 AND TWIST(2)=0 AND TWIST(3)=0 AND TWIST(4)=0        AND TWIST (5)=0 THEN GOTO 2830 ELSE 2890
2830 IF TWIST(6)=0 AND TWIST(7)=0 AND TWIST(8)=0 AND TWIST(9)=0 AND TWIST(10)=0        AND TWIST (11)=0 THEN GOTO 2850        ELSE 2890
2850 LOCATE 1,1:PRINT "ZERO TWIST!";
2860 FOR POW=1    TO     50  :COLL=(POW MOD 4):COLOR POW,POW+1
2870 SOUND 50+POW*100,1:  NEXT POW
2880 COLOR 17,0
2890 REM======================== check counters
2900 IF VERSUS=1 AND DEPTH<LEVEL+PLACE THEN GOTO 2320
2910 IF REPEAT=1 AND REP<CYCLE THEN REP=REP+1:GOTO 2340
2920 VERSUS=0:REPEAT=0
2930 GOTO 1990
2940 REM =====================================================================
2950 GOTO 2950: REM screen buffer save of dots minus circles
2960 TROFF:QL=1
2970  DEF SEG: DEF SEG=&HB800:IF QL=1 GOTO 2990
2980  BSAVE "a:ibmDOT",0,&H4000
2990 CLS: BLOAD "a:ibmDOT",0:DEF SEG
3000 REM STOP
3010 DIM D#(1250 )'get dots into d# array
3020 GET (64,0)-(256,196),D#
3030 GOTO 2950:STOP
3040 PUT (64,0),D#,XOR:STOP
3050 PUT (64,0),D#,XOR:STOP:GOTO 3040
3060 REM =====================================================================
3070 REM             send arrays to disk
3080 IF QL=1 GOTO 3250
3090 OPEN "A:IBMRAY" FOR OUTPUT AS #1
3100 FOR K=0 TO 11:FOR L=0 TO 11
3110 WRITE #1,T(0,L,K),T(1,L,K),T(2,L,K),T(3,L,K)
3120 WRITE #1,T(4,L,K),T(5,L,K),T(6,L,K),T(7,L,K)
3130 WRITE #1,T(8,L,K),T(9,L,K),T(10,L,K),T(11,L,K)
3140 NEXT:NEXT
3150 CLOSE #1
3160 OPEN "A:NBR" FOR OUTPUT AS #2
3170 FOR K=0 TO 11:FOR I=0 TO 4
3180 WRITE #2,BR(K,I):NEXT:NEXT:CLOSE #2
3190 OPEN "A:XOPP" FOR OUTPUT AS #3
3200 FOR K=0 TO 11:FOR Q=0 TO 1
3210 WRITE #3,XN(K,Q):NEXT:NEXT :CLOSE #3
3220 IF QL=0 GOTO 3480
3230 REM =====================================================================
3240 REM                    load from disk to array
3250 DIM T(12,12,12),BR(12,5),XN(12,2)
3260 OPEN "IBMRAY" FOR INPUT AS #1
3270 FOR K=0 TO 11
3280 LOCATE 24,1:PRINT    "                " ;
3290 LOCATE 24,1:PRINT    "loading array   " ;
3300               FOR L=0 TO 11
3310 INPUT #1,T(0,L,K),T(1,L,K),T(2,L,K),T(3,L,K)
3320 INPUT #1,T(4,L,K),T(5,L,K),T(6,L,K),T(7,L,K)
3330 INPUT #1,T(8,L,K),T(9,L,K),T(10,L,K),T(11,L,K)
3340 NEXT
3350 LOCATE 24,40:PRINT    "                " ;
3360 LOCATE 24,40:PRINT    "stand by please " ;
3370      NEXT
3380 CLOSE #1
3390 OPEN "NBR" FOR  INPUT AS #2
3400 FOR K=0 TO 11:FOR I=0 TO 4
3410 INPUT #2,BR(K,I):NEXT:NEXT:CLOSE #2
3420 OPEN "XOPP" FOR  INPUT AS #3
3430 FOR K=0 TO 11:FOR Q=0 TO 1
3440 INPUT #3,XN(K,Q):NEXT:NEXT :CLOSE #3
3450 LOCATE 24,56: PRINT "                      "
3460 LOCATE 24,56: PRINT "press any key to go on"
3470 F$=INKEY$:IF F$="" THEN GOTO 3470
3480  CLS:  SCREEN 1,0:FORG=9 :BACK=0 :BORD=0:COLOR FORG,BACK,BORD:KEY OFF
3490 REM =====================================================================
3500  REM screen buffer load or save
3510  DEF SEG: DEF SEG=&HB800:IF QL=1 GOTO 3530
3520  BSAVE "a:tilpic",0,&H4000
3530 CLS: BLOAD "tilpic",0
3540  GOTO 1760
3550 REM =====================================================================
3560 REM             texture by drawing dots routine
3570 SCREEN 1,0:COLOR 1,0:POLO=1:IF  POLO=1 THEN COLOR 7,1,1:DIA= 60 ELSE DIA=30
3580 CIRCLE (180, 70),DIA
3590 CIRCLE (240,130),DIA :CIRCLE (210,100),DIA
3600 HD=1:VD=1:BOUND=3+4*POLO:FILL=KKOL +POLO*3 :IZ=0:JZ=0
3610 XX=S0 :YY=S1
3620 XF=XX+IZ:YF=YY+JZ: IF POINT(XF,YF)=BOUND      THEN 3650
3630 IF(XF MOD 3)+(YF MOD 3)=0   THEN PSET (XF,YF),FILL
3640 IZ=IZ+HD :GOTO 3620
3650 REM switchbacks
3660 IF HD=1 THEN HD=-1:IZ=0:XR= XF     :GOTO  3620
3670 IF IZ=0 THEN IF VD=-1 THEN RETURN  ELSE VD=-1:IZ=0:JZ=0:HD=1:  GOTO 3610
3680 XL=XF:XX=(XL+XR)/2:HD=1:   IZ=0:JZ=JZ+VD  :GOTO 3620
3690      PRINT IZ;HD;VD;XX;YY:STOP
3700 REM =====================================================================
3710 REM                   texture by animation using xor of dot- screen
3720 SCREEN 1,0:COLOR 1,0:KEY OFF:CLS:HATCHMAKE=0:QL=0' this is dot screen
3730 RANGE=50:JUMP=4:SIDE=JUMP*RANGE:SKIP=(320-SIDE)/2:IF QL=1 THEN 3780
3740 FOR I=0  TO RANGE
3750 FOR J=0  TO RANGE
3760 PSET   (SKIP+I*JUMP,J*JUMP)  ,3
3770 NEXT:NEXT
3780 SIZE=4+INT((SIDE*2+7)/8)*SIDE:RAYSIZE=SIZE\8
3790 STOP
3800  REM screen buffer save of dots minus circles
3810  DEF SEG: DEF SEG=&HB800:IF QL=1 GOTO 3830
3820  BSAVE "a:ibmDOT",0,&H4000
3830 CLS: BLOAD "a:ibmDOT",0:DEF SEG
3840 STOP
3850 DIM D#(1250 )'get dots into d# array
3860 GET (64,0)-(256,196),D#
3870 STOP
3880 PUT (64,0),D#,XOR:STOP
3890 PUT (64,0),D#,XOR:STOP:GOTO 3880
3900 REM =====================================================================
3910  REM screen buffer save of pentagons and circles
3920  DEF SEG: DEF SEG=&HB800:IF QL=1 GOTO 2980
3930  BSAVE "a:ibmCIR",0,&H4000
3940 CLS: BLOAD "a:ibmCIR",0:DEF SEG
3950 STOP
3960 REM =====================================================================
3970 DIM C#(1250   ) 'get pentagons and circles into c# array
3980 GET (64,0)-(256,196),C#
3990 STOP
4000 PUT (64,0),D#,XOR:STOP
4010 PUT (64,0),D#,XOR:STOP:GOTO 4000
4020 REM =====================================================================
4030 REM ===================delete when dip=0 subroutine
4040 DEL=0
4050 IF DIP>0 THEN GOTO 4070
4060 IF STACK(199,1)= 0  THEN DEL=1:GOTO 2080
4070               DEPTH=DEPTH-1:DIP=DEPTH MOD 200:K=STACK(DIP,0):                 ROT=-STACK(DIP,1):STACK(DIP,1)=0
4075 PRINT CHR$(11);"deleting    ";
4076 COLOR 0,1
4080 RETURN   2390
4090 STOP
4100 REM ======================paint:sound command writer
4110 LIN=5670
4120 FOR I=1 TO 25
4130 LIN=LIN+20
4140 PRINT LIN;"PAINT (S0,S1),TIL$(COL) ,3:sound 50+col*tone,dur"
4150 NEXT:STOP
4160 REM =====================================================================
4170 REM==============writer of quick flips
4180 LIN=8100 :R=-2
4190 FOR I=0 TO 4
4200 PRINT I,CHR$(75+BR(K,I))
4210 NEXT
4220 FOR Q=0 TO 0: FOR I=0 TO 4*R STEP     R
4230 L =BR(K,(I  +10)MOD 5):M =BR(K,(I+1  +10) MOD 5)
4240 LL=BR(K,(I+R+10)MOD 5):MM=BR(K,(I+1+R+10) MOD 5)
4250 A(0)=K: A(1)=L: A(2)=M: B(0)=K: B(1)=LL: B(2)=MM
4260 FOR P=2 TO 3:FOR C=0 TO P-1
4270 A0=A((0+C)MOD P): B0=B((0+C)MOD P)
4280 A1=A((1+C)MOD P): B1=B((1+C)MOD P)
4290 A2=A((2+C)MOD P): B2=B((2+C)MOD P)
4300 IF P=2 THEN A2=A1:A1=A0:B2=B1:B1=B0
4310 HM=75:AA0=HM+A0:AA1=HM+A1:AA2=HM+A2:BB0=HM+B0:BB1=HM+B1:BB2=HM+B2
4320 HOL=HOL+1
4330 LIN =LIN +5
4340 IF HOL<=5 THEN  PRINT LIN+1000;                                                  "t("+CHR$(AA2)+","+CHR$(AA1)+","+CHR$(AA0)+")=hol(";HOL;")"
4350 PRINT LIN ;"COL=T("+CHR$(BB2)+","+CHR$(BB1)+","+CHR$(BB0)+"):";
4360 PRINT  "t("+CHR$(AA0)+","+CHR$(AA1)+","+CHR$(AA2)+")=COL:";
4370 IF HOL<=5 THEN  PRINT "HOL(";HOL;")=col:";:GOTO 4390
4380 PRINT  "t("+CHR$(AA2)+","+CHR$(AA1)+","+CHR$(AA0)+")=COL:";
4390 REM IF Q=1 THEN T(A2,A1,A0)=T(A0,A1,A2):     GOTO 4460
4400 REM COL=T(B2,B1,B0):T(A0,A1,A2)=COL
4410 REM KOL=COL MOD 3:KKOL=(KOL+1)MOD 3
4420 XNA1=XN(A1,1):XNA2=XN(A2,1)
4430 XA1=HM+XNA1:XA2=HM+XNA2
4440 S0=T(A0,A1,XNA2):S1=T(A0,XNA1,A2)
4450 PRINT "S0=T("+CHR$(AA0)+","+CHR$(AA1)+","+CHR$(XA2)+"):";
4460 PRINT "S1=T("+CHR$(AA0)+","+CHR$(XA1)+","+CHR$(AA2)+")"
4470 LIN=LIN+5
4480 PRINT LIN;"PAINT (S0,S1),til$(col) ,3:sound 50+col*tone,dur"
4490 REM PAINT (S0,S1),0   ,3
4500 REM TIL$=CHR$(&H44*KOL + &H11*KKOL) +CHR$(&H11*KOL + &H44*KKOL)
4510 REM IF COL<=2 THEN PAINT(S0,S1),KOL,3
4520 REM IF COL> 2 THEN PAINT(S0,S1),TIL$,3
4530 SOUND 50+COL*100,1
4540 REM IF DOTS =1 AND COL>2 THEN GOSUB 4040
4550 REM IF COL>2 THEN  PUT (64,0),D#,XOR
4560 XX=S0:YYY=S1
4570 NEXT C:NEXT P:NEXT I: NEXT Q
4580 STOP
4590 IF VERSUS=1 AND DEPTH<LEVEL+PLACE THEN GOTO 2320
4600 VERSUS=0
4610 GOTO 1990
4620 REM =====================================================================
4630 REM========== quick flip subroutine
4640 RR=ROT
4650 M=BR(K,0):O=BR(K,1):Q= BR (K,2) :S=BR(K,3):U=BR(K,4)
4660 R=XN(M,1):T=XN(O,1):L= XN (Q,1) :N=XN(S,1):P=XN(U,1):V=XN(K,1)
4670 REM  RETURN  2470
4680 TONE=250+100*ROT
4690 IF ROT=-1 THEN GOTO 5290
4700 IF ROT= 2 THEN GOTO 5860
4710 IF ROT=-2 THEN GOTO 6430
4720 COL=T(O,K,K):T(K,K,M)=COL:HOL( 1 )=COL:S0=T(K,K,R):S1=T(K,V,M)
4730 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4740 COL=T(K,O,O):T(M,M,K)=COL:HOL( 2 )=COL:S0=T(M,M,V):S1=T(M,R,K)
4750 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4760 COL=T(Q,O,K):T(K,M,O)=COL:HOL( 3 )=COL:S0=T(K,M,T):S1=T(K,R,O)
4770 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4780 COL=T(K,Q,O):T(M,O,K)=COL:HOL( 4 )=COL:S0=T(M,O,V):S1=T(M,T,K)
4790 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4800 COL=T(O,K,Q):T(O,K,M)=COL:HOL( 5 )=COL:S0=T(O,K,R):S1=T(O,V,M)
4810 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4820 COL=T(Q,K,K):T(K,K,O)=COL:T(O,K,K)=COL:S0=T(K,K,T):S1=T(K,V,O)
4830 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4840 COL=T(K,Q,Q):T(O,O,K)=COL:T(K,O,O)=COL:S0=T(O,O,V):S1=T(O,T,K)
4850 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4860 COL=T(S,Q,K):T(K,O,Q)=COL:T(Q,O,K)=COL:S0=T(K,O,L):S1=T(K,T,Q)
4870 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4880 COL=T(K,S,Q):T(O,Q,K)=COL:T(K,Q,O)=COL:S0=T(O,Q,V):S1=T(O,L,K)
4890 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4900 COL=T(Q,K,S):T(Q,K,O)=COL:T(O,K,Q)=COL:S0=T(Q,K,T):S1=T(Q,V,O)
4910 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4920 COL=T(S,K,K):T(K,K,Q)=COL:T(Q,K,K)=COL:S0=T(K,K,L):S1=T(K,V,Q)
4930 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4940 COL=T(K,S,S):T(Q,Q,K)=COL:T(K,Q,Q)=COL:S0=T(Q,Q,V):S1=T(Q,L,K)
4950 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4960 COL=T(U,S,K):T(K,Q,S)=COL:T(S,Q,K)=COL:S0=T(K,Q,N):S1=T(K,L,S)
4970 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
4980 COL=T(K,U,S):T(Q,S,K)=COL:T(K,S,Q)=COL:S0=T(Q,S,V):S1=T(Q,N,K)
4990 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5000 COL=T(S,K,U):T(S,K,Q)=COL:T(Q,K,S)=COL:S0=T(S,K,L):S1=T(S,V,Q)
5010 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5020 COL=T(U,K,K):T(K,K,S)=COL:T(S,K,K)=COL:S0=T(K,K,N):S1=T(K,V,S)
5030 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5040 COL=T(K,U,U):T(S,S,K)=COL:T(K,S,S)=COL:S0=T(S,S,V):S1=T(S,N,K)
5050 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5060 COL=T(M,U,K):T(K,S,U)=COL:T(U,S,K)=COL:S0=T(K,S,P):S1=T(K,N,U)
5070 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5080 COL=T(K,M,U):T(S,U,K)=COL:T(K,U,S)=COL:S0=T(S,U,V):S1=T(S,P,K)
5090 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5100 COL=T(U,K,M):T(U,K,S)=COL:T(S,K,U)=COL:S0=T(U,K,N):S1=T(U,V,S)
5110 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5120 COL=T(M,K,K):T(K,K,U)=COL:T(U,K,K)=COL:S0=T(K,K,P):S1=T(K,V,U)
5130 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5140 COL=T(K,M,M):T(U,U,K)=COL:T(K,U,U)=COL:S0=T(U,U,V):S1=T(U,P,K)
5150 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5160 COL=T(O,M,K):T(K,U,M)=COL:T(M,U,K)=COL:S0=T(K,U,R):S1=T(K,P,M)
5170 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5180 COL=T(K,O,M):T(U,M,K)=COL:T(K,M,U)=COL:S0=T(U,M,V):S1=T(U,R,K)
5190 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5200 COL=T(M,K,O):T(M,K,U)=COL:T(U,K,M)=COL:S0=T(M,K,P):S1=T(M,V,U)
5210 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5220 T(M,K,K)=HOL( 1 )
5230 T(K,M,M)=HOL( 2 )
5240 T(O,M,K)=HOL( 3 )
5250 T(K,O,M)=HOL( 4 )
5260 T(M,K,O)=HOL( 5 )
5270 RETURN  2790
5280 STOP
5290 REM ===================reverse flip
5300 COL=T(U,K,K):T(K,K,M)=COL:HOL( 1 )=COL:S0=T(K,K,R):S1=T(K,V,M)
5310 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5320 COL=T(K,U,U):T(M,M,K)=COL:HOL( 2 )=COL:S0=T(M,M,V):S1=T(M,R,K)
5330 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5340 COL=T(M,U,K):T(K,M,O)=COL:HOL( 3 )=COL:S0=T(K,M,T):S1=T(K,R,O)
5350 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5360 COL=T(K,M,U):T(M,O,K)=COL:HOL( 4 )=COL:S0=T(M,O,V):S1=T(M,T,K)
5370 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5380 COL=T(U,K,M):T(O,K,M)=COL:HOL( 5 )=COL:S0=T(O,K,R):S1=T(O,V,M)
5390 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5400 COL=T(S,K,K):T(K,K,U)=COL:T(U,K,K)=COL:S0=T(K,K,P):S1=T(K,V,U)
5410 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5420 COL=T(K,S,S):T(U,U,K)=COL:T(K,U,U)=COL:S0=T(U,U,V):S1=T(U,P,K)
5430 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5440 COL=T(U,S,K):T(K,U,M)=COL:T(M,U,K)=COL:S0=T(K,U,R):S1=T(K,P,M)
5450 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5460 COL=T(K,U,S):T(U,M,K)=COL:T(K,M,U)=COL:S0=T(U,M,V):S1=T(U,R,K)
5470 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5480 COL=T(S,K,U):T(M,K,U)=COL:T(U,K,M)=COL:S0=T(M,K,P):S1=T(M,V,U)
5490 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5500 COL=T(Q,K,K):T(K,K,S)=COL:T(S,K,K)=COL:S0=T(K,K,N):S1=T(K,V,S)
5510 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5520 COL=T(K,Q,Q):T(S,S,K)=COL:T(K,S,S)=COL:S0=T(S,S,V):S1=T(S,N,K)
5530 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5540 COL=T(S,Q,K):T(K,S,U)=COL:T(U,S,K)=COL:S0=T(K,S,P):S1=T(K,N,U)
5550 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5560 COL=T(K,S,Q):T(S,U,K)=COL:T(K,U,S)=COL:S0=T(S,U,V):S1=T(S,P,K)
5570 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5580 COL=T(Q,K,S):T(U,K,S)=COL:T(S,K,U)=COL:S0=T(U,K,N):S1=T(U,V,S)
5590 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5600 COL=T(O,K,K):T(K,K,Q)=COL:T(Q,K,K)=COL:S0=T(K,K,L):S1=T(K,V,Q)
5610 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5620 COL=T(K,O,O):T(Q,Q,K)=COL:T(K,Q,Q)=COL:S0=T(Q,Q,V):S1=T(Q,L,K)
5630 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5640 COL=T(Q,O,K):T(K,Q,S)=COL:T(S,Q,K)=COL:S0=T(K,Q,N):S1=T(K,L,S)
5650 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5660 COL=T(K,Q,O):T(Q,S,K)=COL:T(K,S,Q)=COL:S0=T(Q,S,V):S1=T(Q,N,K)
5670 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5680 COL=T(O,K,Q):T(S,K,Q)=COL:T(Q,K,S)=COL:S0=T(S,K,L):S1=T(S,V,Q)
5690 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5700 COL=T(M,K,K):T(K,K,O)=COL:T(O,K,K)=COL:S0=T(K,K,T):S1=T(K,V,O)
5710 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5720 COL=T(K,M,M):T(O,O,K)=COL:T(K,O,O)=COL:S0=T(O,O,V):S1=T(O,T,K)
5730 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5740 COL=T(O,M,K):T(K,O,Q)=COL:T(Q,O,K)=COL:S0=T(K,O,L):S1=T(K,T,Q)
5750 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5760 COL=T(K,O,M):T(O,Q,K)=COL:T(K,Q,O)=COL:S0=T(O,Q,V):S1=T(O,L,K)
5770 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5780 COL=T(M,K,O):T(Q,K,O)=COL:T(O,K,Q)=COL:S0=T(Q,K,T):S1=T(Q,V,O)
5790 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5800 T(M,K,K)=HOL( 1 )
5810 T(K,M,M)=HOL( 2 )
5820 T(O,M,K)=HOL( 3 )
5830 T(K,O,M)=HOL( 4 )
5840 T(M,K,O)=HOL( 5 )
5850 RETURN 2790
5860 REM==================double positve flip
5870 COL=T(Q,K,K):T(K,K,M)=COL:HOL( 1 )=COL:S0=T(K,K,R):S1=T(K,V,M)
5880 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5890 COL=T(K,Q,Q):T(M,M,K)=COL:HOL( 2 )=COL:S0=T(M,M,V):S1=T(M,R,K)
5900 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5910 COL=T(S,Q,K):T(K,M,O)=COL:HOL( 3 )=COL:S0=T(K,M,T):S1=T(K,R,O)
5920 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5930 COL=T(K,S,Q):T(M,O,K)=COL:HOL( 4 )=COL:S0=T(M,O,V):S1=T(M,T,K)
5940 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5950 COL=T(Q,K,S):T(O,K,M)=COL:HOL( 5 )=COL:S0=T(O,K,R):S1=T(O,V,M)
5960 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5970 COL=T(U,K,K):T(K,K,Q)=COL:T(Q,K,K)=COL:S0=T(K,K,L):S1=T(K,V,Q)
5980 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
5990 COL=T(K,U,U):T(Q,Q,K)=COL:T(K,Q,Q)=COL:S0=T(Q,Q,V):S1=T(Q,L,K)
6000 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6010 COL=T(M,U,K):T(K,Q,S)=COL:T(S,Q,K)=COL:S0=T(K,Q,N):S1=T(K,L,S)
6020 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6030 COL=T(K,M,U):T(Q,S,K)=COL:T(K,S,Q)=COL:S0=T(Q,S,V):S1=T(Q,N,K)
6040 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6050 COL=T(U,K,M):T(S,K,Q)=COL:T(Q,K,S)=COL:S0=T(S,K,L):S1=T(S,V,Q)
6060 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6070 COL=T(O,K,K):T(K,K,U)=COL:T(U,K,K)=COL:S0=T(K,K,P):S1=T(K,V,U)
6080 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6090 COL=T(K,O,O):T(U,U,K)=COL:T(K,U,U)=COL:S0=T(U,U,V):S1=T(U,P,K)
6100 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6110 COL=T(Q,O,K):T(K,U,M)=COL:T(M,U,K)=COL:S0=T(K,U,R):S1=T(K,P,M)
6120 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6130 COL=T(K,Q,O):T(U,M,K)=COL:T(K,M,U)=COL:S0=T(U,M,V):S1=T(U,R,K)
6140 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6150 COL=T(O,K,Q):T(M,K,U)=COL:T(U,K,M)=COL:S0=T(M,K,P):S1=T(M,V,U)
6160 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6170 COL=T(S,K,K):T(K,K,O)=COL:T(O,K,K)=COL:S0=T(K,K,T):S1=T(K,V,O)
6180 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6190 COL=T(K,S,S):T(O,O,K)=COL:T(K,O,O)=COL:S0=T(O,O,V):S1=T(O,T,K)
6200 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6210 COL=T(U,S,K):T(K,O,Q)=COL:T(Q,O,K)=COL:S0=T(K,O,L):S1=T(K,T,Q)
6220 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6230 COL=T(K,U,S):T(O,Q,K)=COL:T(K,Q,O)=COL:S0=T(O,Q,V):S1=T(O,L,K)
6240 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6250 COL=T(S,K,U):T(Q,K,O)=COL:T(O,K,Q)=COL:S0=T(Q,K,T):S1=T(Q,V,O)
6260 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6270 COL=T(M,K,K):T(K,K,S)=COL:T(S,K,K)=COL:S0=T(K,K,N):S1=T(K,V,S)
6280 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6290 COL=T(K,M,M):T(S,S,K)=COL:T(K,S,S)=COL:S0=T(S,S,V):S1=T(S,N,K)
6300 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6310 COL=T(O,M,K):T(K,S,U)=COL:T(U,S,K)=COL:S0=T(K,S,P):S1=T(K,N,U)
6320 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6330 COL=T(K,O,M):T(S,U,K)=COL:T(K,U,S)=COL:S0=T(S,U,V):S1=T(S,P,K)
6340 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6350 COL=T(M,K,O):T(U,K,S)=COL:T(S,K,U)=COL:S0=T(U,K,N):S1=T(U,V,S)
6360 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6370 T(M,K,K)=HOL( 1 )
6380 T(K,M,M)=HOL( 2 )
6390 T(O,M,K)=HOL( 3 )
6400 T(K,O,M)=HOL( 4 )
6410 T(M,K,O)=HOL( 5 )
6420 RETURN  2790
6430 REM ========================double negative flip
6440 COL=T(S,K,K):T(K,K,M)=COL:HOL( 1 )=COL:S0=T(K,K,R):S1=T(K,V,M)
6450 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6460 COL=T(K,S,S):T(M,M,K)=COL:HOL( 2 )=COL:S0=T(M,M,V):S1=T(M,R,K)
6470 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6480 COL=T(U,S,K):T(K,M,O)=COL:HOL( 3 )=COL:S0=T(K,M,T):S1=T(K,R,O)
6490 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6500 COL=T(K,U,S):T(M,O,K)=COL:HOL( 4 )=COL:S0=T(M,O,V):S1=T(M,T,K)
6510 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6520 COL=T(S,K,U):T(O,K,M)=COL:HOL( 5 )=COL:S0=T(O,K,R):S1=T(O,V,M)
6530 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6540 COL=T(O,K,K):T(K,K,S)=COL:T(S,K,K)=COL:S0=T(K,K,N):S1=T(K,V,S)
6550 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6560 COL=T(K,O,O):T(S,S,K)=COL:T(K,S,S)=COL:S0=T(S,S,V):S1=T(S,N,K)
6570 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6580 COL=T(Q,O,K):T(K,S,U)=COL:T(U,S,K)=COL:S0=T(K,S,P):S1=T(K,N,U)
6590 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6600 COL=T(K,Q,O):T(S,U,K)=COL:T(K,U,S)=COL:S0=T(S,U,V):S1=T(S,P,K)
6610 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6620 COL=T(O,K,Q):T(U,K,S)=COL:T(S,K,U)=COL:S0=T(U,K,N):S1=T(U,V,S)
6630 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6640 COL=T(U,K,K):T(K,K,O)=COL:T(O,K,K)=COL:S0=T(K,K,T):S1=T(K,V,O)
6650 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6660 COL=T(K,U,U):T(O,O,K)=COL:T(K,O,O)=COL:S0=T(O,O,V):S1=T(O,T,K)
6670 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6680 COL=T(M,U,K):T(K,O,Q)=COL:T(Q,O,K)=COL:S0=T(K,O,L):S1=T(K,T,Q)
6690 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6700 COL=T(K,M,U):T(O,Q,K)=COL:T(K,Q,O)=COL:S0=T(O,Q,V):S1=T(O,L,K)
6710 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6720 COL=T(U,K,M):T(Q,K,O)=COL:T(O,K,Q)=COL:S0=T(Q,K,T):S1=T(Q,V,O)
6730 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6740 COL=T(Q,K,K):T(K,K,U)=COL:T(U,K,K)=COL:S0=T(K,K,P):S1=T(K,V,U)
6750 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6760 COL=T(K,Q,Q):T(U,U,K)=COL:T(K,U,U)=COL:S0=T(U,U,V):S1=T(U,P,K)
6770 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6780 COL=T(S,Q,K):T(K,U,M)=COL:T(M,U,K)=COL:S0=T(K,U,R):S1=T(K,P,M)
6790 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6800 COL=T(K,S,Q):T(U,M,K)=COL:T(K,M,U)=COL:S0=T(U,M,V):S1=T(U,R,K)
6810 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6820 COL=T(Q,K,S):T(M,K,U)=COL:T(U,K,M)=COL:S0=T(M,K,P):S1=T(M,V,U)
6830 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6840 COL=T(M,K,K):T(K,K,Q)=COL:T(Q,K,K)=COL:S0=T(K,K,L):S1=T(K,V,Q)
6850 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6860 COL=T(K,M,M):T(Q,Q,K)=COL:T(K,Q,Q)=COL:S0=T(Q,Q,V):S1=T(Q,L,K)
6870 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6880 COL=T(O,M,K):T(K,Q,S)=COL:T(S,Q,K)=COL:S0=T(K,Q,N):S1=T(K,L,S)
6890 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6900 COL=T(K,O,M):T(Q,S,K)=COL:T(K,S,Q)=COL:S0=T(Q,S,V):S1=T(Q,N,K)
6910 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6920 COL=T(M,K,O):T(S,K,Q)=COL:T(Q,K,S)=COL:S0=T(S,K,L):S1=T(S,V,Q)
6930 PAINT (S0,S1),TIL$(COL) ,3:SOUND 50+COL*TONE,DUR
6940 T(M,K,K)=HOL( 1 )
6950 T(K,M,M)=HOL( 2 )
6960 T(O,M,K)=HOL( 3 )
6970 T(K,O,M)=HOL( 4 )
6980 T(M,K,O)=HOL( 5 )
6990 RETURN 2790
7000 F$=INKEY$:IF F$="" THEN GOTO 7000
7010 PRINT ASC(RIGHT$(F$,1)):GOTO 7000
